<?php
/**
 * News functions
 *
 * You may not change or alter any portion of this comment or credits
 * of supporting developers from this source code or any supporting source code
 * which is considered copyrighted (c) material of the original comment or credit authors.
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * @copyright   The XOOPS Project http://sourceforge.net/projects/xoops/
 * @license     GNU GPL 2 (http://www.gnu.org/licenses/old-licenses/gpl-2.0.html)
 * @author      Voltan
 * @package     News
 * @version     $Id: update_function.php 9765 2012-07-02 05:38:02Z beckmi $
 */

function xoops_module_update_news() {

	include_once XOOPS_ROOT_PATH.'/modules/news/include/functions.php';
   global $xoopsDB;
   
	// 1) Create, if it does not exists, the stories_files table
	if(!news_TableExists($xoopsDB->prefix('stories_files')))
	{
		$sql = 'CREATE TABLE '.$xoopsDB->prefix('stories_files')." (
  			fileid int(8) unsigned NOT NULL auto_increment,
  			filerealname varchar(255) NOT NULL default '',
  			storyid int(8) unsigned NOT NULL default '0',
  			date int(10) NOT NULL default '0',
  			mimetype varchar(64) NOT NULL default '',
  			downloadname varchar(255) NOT NULL default '',
  			counter int(8) unsigned NOT NULL default '0',
  			PRIMARY KEY  (fileid),
  			KEY storyid (storyid)
			) ENGINE=MyISAM;";
		if (!$xoopsDB->queryF($sql)) {
	    	echo '<br />' . _AM_NEWS_UPGRADEFAILED.' '._AM_NEWS_UPGRADEFAILED1;
	    	$errors++;
		}
	}

	// 2) Change the topic title's length, in the topics table
	$sql=sprintf('ALTER TABLE ' . $xoopsDB->prefix('topics') . ' CHANGE topic_title topic_title VARCHAR( 255 ) NOT NULL;');
	$result=$xoopsDB->queryF($sql);
	if (!$result) {
    	echo '<br />' .  _AM_NEWS_UPGRADEFAILED.' '._AM_NEWS_UPGRADEFAILED2;
    	$errors++;
	}

	// 2.1) Add the new fields to the topic table
	if (!news_FieldExists('menu',$xoopsDB->prefix('topics'))) {
		news_AddField("menu TINYINT( 1 ) DEFAULT '0' NOT NULL",$xoopsDB->prefix('topics'));
	}
	if (!news_FieldExists('topic_frontpage',$xoopsDB->prefix('topics'))) {
		news_AddField("topic_frontpage TINYINT( 1 ) DEFAULT '1' NOT NULL",$xoopsDB->prefix('topics'));
	}
	if (!news_FieldExists('topic_rssurl',$xoopsDB->prefix('topics'))) {
		news_AddField("topic_rssurl VARCHAR( 255 ) NOT NULL",$xoopsDB->prefix('topics'));
	}
	if (!news_FieldExists('topic_description',$xoopsDB->prefix('topics'))) {
		news_AddField("topic_description TEXT NOT NULL",$xoopsDB->prefix('topics'));
	}
	if (!news_FieldExists('topic_color',$xoopsDB->prefix('topics'))) {
		news_AddField("topic_color varchar(6) NOT NULL default '000000'",$xoopsDB->prefix('topics'));
	}

	// 3) If it does not exists, create the table stories_votedata
	if(!news_TableExists($xoopsDB->prefix('stories_votedata')))
	{
		$sql = 'CREATE TABLE '.$xoopsDB->prefix('stories_votedata')." (
  			ratingid int(11) unsigned NOT NULL auto_increment,
  			storyid int(8) unsigned NOT NULL default '0',
  			ratinguser int(11) NOT NULL default '0',
  			rating tinyint(3) unsigned NOT NULL default '0',
  			ratinghostname varchar(60) NOT NULL default '',
  			ratingtimestamp int(10) NOT NULL default '0',
  			PRIMARY KEY  (ratingid),
  			KEY ratinguser (ratinguser),
  			KEY ratinghostname (ratinghostname),
  			KEY storyid (storyid)
			) ENGINE=MyISAM;";
		if (!$xoopsDB->queryF($sql)) {
	    	echo '<br />' .  _AM_NEWS_UPGRADEFAILED.' '._AM_NEWS_UPGRADEFAILED3;
	    	$errors++;
		}
	}

	// 4) Create the four new fields for the votes in the story table
	if (!news_FieldExists('rating',$xoopsDB->prefix('stories'))) {
		news_AddField("rating DOUBLE( 6, 4 ) DEFAULT '0.0000' NOT NULL",$xoopsDB->prefix('stories'));
	}
	if (!news_FieldExists('votes',$xoopsDB->prefix('stories'))) {
		news_AddField("votes INT( 11 ) UNSIGNED DEFAULT '0' NOT NULL",$xoopsDB->prefix('stories'));
	}
	if (!news_FieldExists('keywords',$xoopsDB->prefix('stories'))) {
		news_AddField("keywords VARCHAR(255) NOT NULL",$xoopsDB->prefix('stories'));
	}
	if (!news_FieldExists('description',$xoopsDB->prefix('stories'))) {
		news_AddField("description VARCHAR(255) NOT NULL",$xoopsDB->prefix('stories'));
	}
	if (!news_FieldExists('pictureinfo',$xoopsDB->prefix('stories'))) {
		news_AddField("pictureinfo VARCHAR(255) NOT NULL",$xoopsDB->prefix('stories'));
	}
	if (!news_FieldExists('subtitle',$xoopsDB->prefix('stories'))) {
		news_AddField("subtitle VARCHAR(255) NOT NULL",$xoopsDB->prefix('stories'));
	}

	// 5) Add some indexes to the topics table
	$sql=sprintf('ALTER TABLE ' . $xoopsDB->prefix('topics') . " ADD INDEX ( `topic_title` );");
	$result=$xoopsDB->queryF($sql);
	$sql=sprintf('ALTER TABLE ' . $xoopsDB->prefix('topics') . " ADD INDEX ( `menu` );");
	$result=$xoopsDB->queryF($sql);
	
	// 6) Make files and folders
    $dir = XOOPS_ROOT_PATH . "/uploads/news";
    if (!is_dir($dir)) {
        mkdir($dir);
        chmod($dir, 0777);
    } elseif (!is_writeable($dir)) {
        chmod($dir, 0777);
    }

	$dir = XOOPS_ROOT_PATH."/uploads/news/file";
    if (!is_dir($dir)) {
        mkdir($dir);
        chmod($dir, 0777);
    } elseif (!is_writeable($dir)) {
        chmod($dir, 0777);
    }
	   
	$dir = XOOPS_ROOT_PATH."/uploads/news/image";
    if (!is_dir($dir)) {
        mkdir($dir);
        chmod($dir, 0777);
    } elseif (!is_writeable($dir)) {
        chmod($dir, 0777);
    }
	
	// Copy index.html files on uploads folders
	$indexFile = XOOPS_ROOT_PATH."/modules/news/include/index.html";
   copy($indexFile, XOOPS_ROOT_PATH."/uploads/news/index.html");
   copy($indexFile, XOOPS_ROOT_PATH."/uploads/news/file/index.html");
	copy($indexFile, XOOPS_ROOT_PATH."/uploads/news/image/index.html");

	return TRUE;
 
}  
?>