<?php
// $Id: xoops_version.php,v 1.3 19:46 2010-01-06 Mazarin Exp $
//  ------------------------------------------------------------------------ //
//                XOOPS - PHP Content Management System                      //
//                    Copyright (c) 2000 XOOPS.org                           //
//                       <http://www.xoops.org/>                             //
//  ------------------------------------------------------------------------ //
//  This program is free software; you can redistribute it and/or modify     //
//  it under the terms of the GNU General Public License as published by     //
//  the Free Software Foundation; either version 2 of the License, or        //
//  (at your option) any later version.                                      //
//                                                                           //
//  You may not change or alter any portion of this comment or credits       //
//  of supporting developers from this source code or any supporting         //
//  source code which is considered copyrighted (c) material of the          //
//  original comment or credit authors.                                      //
//                                                                           //
//  This program is distributed in the hope that it will be useful,          //
//  but WITHOUT ANY WARRANTY; without even the implied warranty of           //
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            //
//  GNU General Public License for more details.                             //
//                                                                           //
//  You should have received a copy of the GNU General Public License        //
//  along with this program; if not, write to the Free Software              //
//  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA //
//  ------------------------------------------------------------------------ //

defined( 'XOOPS_ROOT_PATH' ) or die( 'Restricted access' );
$moduleDirName = basename( dirname( __FILE__ ) ) ;

$modversion['name'] = _MI_POLLS_NAME;
$modversion['version'] = 1.33;
$modversion['description'] = _MI_POLLS_DESC;
$modversion['author'] = "Kazumi Ono, modified by Mazarin";
$modversion['credits'] = "The XOOPS Project, Mamba";
$modversion['help'] = 'page=help';
$modversion['license'] = 'GNU GPL 2.0';
$modversion['license_url'] = "www.gnu.org/licenses/gpl-2.0.html/";
$modversion['official'] = 1;
$modversion['image'] = "images/xoopspoll_slogo.png";
$modversion['dirname'] = "xoopspoll";
$modversion['dirmoduleadmin'] = 'Frameworks/moduleclasses';
$modversion['icons16'] = 'Frameworks/moduleclasses/icons/16';
$modversion['icons32'] = 'Frameworks/moduleclasses/icons/32';

//about
$modversion['demo_site_url'] = "";
$modversion['demo_site_name'] = "";
$modversion['module_website_url'] = "http://xoops.org";
$modversion['module_website_name'] = "XOOPS";
$modversion['release_date'] = "2011/04/02";
$modversion['module_status'] = "RC";
$modversion["author_website_url"] = "http://www.myweb.ne.jp";
$modversion["author_website_name"] = "Kazumi Ono";
$modversion['min_php']='5.2';
$modversion['min_xoops']="2.5.0";


// Sql file (must contain sql generated by phpMyAdmin or phpPgAdmin)
// All tables should not have any prefix!
$modversion['sqlfile']['mysql'] = "sql/mysql.sql";
//$modversion['sqlfile']['postgresql'] = "sql/pgsql.sql";



// Tables created by sql file (without prefix!)
$modversion['tables'][0] = "xoopspoll_option";
$modversion['tables'][1] = "xoopspoll_desc";
$modversion['tables'][2] = "xoopspoll_log";



// Admin things
$modversion['hasAdmin'] = 1;
$modversion['adminindex'] = "admin/index.php";
$modversion['adminmenu'] = "admin/menu.php";

// Admin menu
// Set to 1 if you want to display menu generated by system module
$modversion['system_menu'] = 1;


// Templates
$i = 1;
$modversion['templates'][$i]['file'] = 'xoopspoll_index.html';
$modversion['templates'][$i]['description'] = '';
$i++;
$modversion['templates'][$i]['file'] = 'xoopspoll_view.html';
$modversion['templates'][$i]['description'] = '';
$i++;
$modversion['templates'][$i]['file'] = 'xoopspoll_results.html';
$modversion['templates'][$i]['description'] = '';
$i++;
$modversion["templates"][$i]["file"] 		=  $moduleDirName . "_admin_about.html";
$modversion["templates"][$i]["description"] 	= "";
$i++;
$modversion["templates"][$i]["file"] 		=  $moduleDirName . "_admin_help.html";
$modversion["templates"][$i]["description"] 	= "";


//Blocks
$modversion['blocks'][1]['file'] = "xoopspoll.php";
$modversion['blocks'][1]['name'] = _MI_POLLS_BNAME1;
$modversion['blocks'][1]['description'] = "Shows unlimited number of polls/surveys";
$modversion['blocks'][1]['show_func'] = "b_xoopspoll_show";
$modversion['blocks'][1]['template'] = 'xoopspoll_block_poll.html';

//config
$modversion['config'][0] = array(
  'name'      => "limit_by_ip" ,
  'title'     => '_MI_POLL_LIMITBYIP' ,
  'description' => '_MI_POLL_LIMITBYIPD' ,
  'formtype'    => 'yesno' ,
  'valuetype'   => 'int' ,
  'default'   => '1' ,
  'options'   => array()
) ;

//config
$modversion['config'][1] = array(
  'name'      => "limit_by_uid" ,
  'title'     => '_MI_POLL_LIMITBYUID' ,
  'description' => '_MI_POLL_LIMITBYUIDD' ,
  'formtype'    => 'yesno' ,
  'valuetype'   => 'int' ,
  'default'   => '0' ,
  'options'   => array()
) ;


// Menu
$modversion['hasMain'] = 1;

// Comments
$modversion['hasComments'] = 1;
$modversion['comments']['pageName'] = 'pollresults.php';
$modversion['comments']['itemName'] = 'poll_id';