<?php
/*
 You may not change or alter any portion of this comment or credits
 of supporting developers from this source code or any supporting source code 
 which is considered copyrighted (c) material of the original comment or credit authors.
 
 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
*/

/**
 * XOOPS tag management module
 *
 * @copyright       The XOOPS project http://sourceforge.net/projects/xoops/
 * @license         http://www.fsf.org/copyleft/gpl.html GNU public license
 * @since           1.0.0
 * @author          Taiwen Jiang <phppp@users.sourceforge.net>
 * @version         $Id: xoops_version.php 2292 2008-10-12 04:53:18Z phppp $
 * @package         tag
 */


if (!defined('XOOPS_ROOT_PATH')) { exit(); }

$moduleDirName = basename( dirname( __FILE__ ) ) ;

$modversion = array();
$modversion["name"]         = TAG_MI_NAME;
$modversion["version"]      = 2.31;
$modversion["description"]  = TAG_MI_DESC;
$modversion["image"]        = "images/logoTag.png";
$modversion["dirname"]      = "tag";
$modversion["author"]       = "Taiwen Jiang <phppp@users.sourceforge.net>";
$modversion['nickname'] = "phppp";
$modversion["credits"]	= "http://xoops.org, Trabis, Mamba";
$modversion['help'] = 'page=help';
$modversion["license"] 	= "GNU General Public License";
$modversion["license_url"]	= "http://www.gnu.org/licenses/gpl.html";
$modversion["official"] 	= 0;
$modversion["author_website_url"]	= "http://xoops.org";
$modversion["author_website_name"]	= "XOOPS";
$modversion['dirmoduleadmin'] = 'Frameworks/moduleclasses';
$modversion['icons16'] = 'Frameworks/moduleclasses/icons/16';
$modversion['icons32'] = 'Frameworks/moduleclasses/icons/32';

//about
$modversion["release_date"] = "2011/05/10";
$modversion["demo_site_url"]			= "";
$modversion["demo_site_name"]			= "";
$modversion["module_website_url"]		= "http://xoops.org";
$modversion["module_website_name"]	= "XOOPS";
$modversion["module_status"]			= "Beta 2";
$modversion['min_php'] = '5.2';
$modversion['min_xoops'] = "2.5.0";



// database tables
$modversion["sqlfile"]["mysql"] = "sql/mysql.sql";
$modversion["tables"] = array(
    "tag_tag",
    "tag_link",
    "tag_stats",
);

// Admin things
$modversion["hasAdmin"] = 1;
$modversion["adminindex"] = "admin/index.php";
$modversion["adminmenu"] = "admin/menu.php";

// Menu
$modversion["hasMain"] = 1;

// Admin menu
// Set to 1 if you want to display menu generated by system module
$modversion['system_menu'] = 1;

$modversion["onInstall"] = "include/action.module.php";
$modversion["onUpdate"] = "include/action.module.php";
$modversion["onUninstall"] = "include/action.module.php";

// Use smarty
$modversion["use_smarty"] = 1;

/**
* Templates
*/
// $modversion['templates']    = array();
// $modversion['templates'][1]    = array(
    // 'file'          => 'tag_index.html',
    // 'description'   => 'Index page of tag module'
    // );
// $modversion['templates'][]    = array(
    // 'file'          => 'tag_list.html',
    // 'description'   => 'List of tags'
    // );
// $modversion['templates'][]    = array(
    // 'file'          => 'tag_view.html',
    // 'description'   => 'Links of a tag'
    // );
// $modversion['templates'][]    = array(
    // 'file'          => 'tag_bar.html',
    // 'description'   => 'Tag list in an item'
    // );


// Templates
$i = 1;
$modversion["templates"][$i]["file"] 		= "tag_index.html";
$modversion["templates"][$i]["description"] 	= "Index page of tag module";
$i++;
$modversion["templates"][$i]["file"] 		= "tag_list.html";
$modversion["templates"][$i]["description"] 	= "List of tags";
$i++;
$modversion["templates"][$i]["file"] 		= "tag_view.html";
$modversion["templates"][$i]["description"] 	= "Links of a tag";
$i++;
$modversion["templates"][$i]["file"] 		= "tag_bar.html";
$modversion["templates"][$i]["description"] 	= "Tag list in an item";
$i++;
$modversion["templates"][$i]["file"] 		= "admin/" . $moduleDirName . "_admin_about.html";
$modversion["templates"][$i]["description"] 	= "";
$i++;
$modversion["templates"][$i]["file"] 		= "admin/" . $moduleDirName . "_admin_help.html";
$modversion["templates"][$i]["description"] 	= "";



// Blocks
$modversion['blocks']    = array();

/*
 * $options:  
 *                    $options[0] - number of tags to display
 *                    $options[1] - max font size (px or %)
 *                    $options[2] - min font size (px or %)
 */
$modversion["blocks"][1]    = array(
    "file"          => "block.php",
    "name"          => TAG_MI_BLOCK_CLOUD,
    "description"   => TAG_MI_BLOCK_CLOUD_DESC,
    "show_func"     => "tag_block_cloud_show",
    "edit_func"     => "tag_block_cloud_edit",
    "options"       => "100|0|150|80",
    "template"      => "tag_block_cloud.html",
    );

/*
 * $options:  
 *                    $options[0] - number of tags to display
 *                    $options[1] - time duration, in days, 0 for all the time
 *                    $options[2] - sort: a - alphabet; c - count; t - time
 */
$modversion["blocks"][]    = array(
    "file"          => "block.php",
    "name"          => TAG_MI_BLOCK_TOP,
    "description"   => TAG_MI_BLOCK_TOP_DESC,
    "show_func"     => "tag_block_top_show",
    "edit_func"     => "tag_block_top_edit",
    "options"       => "50|30|a",
    "template"      => "tag_block_top.html",
    );

// Search
$modversion["hasSearch"] = 1;
$modversion['search']['file'] = "include/search.inc.php";
$modversion['search']['func'] = "tag_search";

// Comments
$modversion["hasComments"] = 0;

// Configs
$modversion["config"] = array();
    
$modversion["config"][1] = array(
    "name"          => "do_urw",
    "title"         => "TAG_MI_DOURLREWRITE",
    "description"   => "TAG_MI_DOURLREWRITE_DESC",
    "formtype"      => "yesno",
    "valuetype"     => "int",
    "default"       => in_array(php_sapi_name(), array("apache", "apache2handler")),
    );

$modversion["config"][] = array(
    "name"          => "items_perpage",
    "title"         => "TAG_MI_ITEMSPERPAGE",
    "description"   => "TAG_MI_ITEMSPERPAGE_DESC",
    "formtype"      => "textbox",
    "valuetype"     => "int",
    "default"       => 10
    );


// Notification

$modversion["hasNotification"] = 0;
$modversion["notification"] = array();
?>