/*
 * Decompiled with CFR 0.152.
 */
package wjhk.jupload2.upload.helper;

import java.net.URL;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CookieJar {
    static final Pattern pNvPair = Pattern.compile("^\\s*([^=\\s]+)(\\s*=\\s*(.+))*$", 2);
    private HashMap<String, Cookie> jar = new HashMap();
    private String domain = null;

    private String stripQuotes(String s) {
        if (s.startsWith("\"") && s.endsWith("\"")) {
            return s.substring(1, s.length() - 1);
        }
        return s;
    }

    private boolean domainMatch(String cd) {
        int dot;
        if (!cd.startsWith(".") && (dot = cd.indexOf(46)) >= 0) {
            cd = cd.substring(dot);
        }
        return cd.equals(this.domain);
    }

    public void setDomain(String domain) {
        int dot;
        if (!domain.startsWith(".") && (dot = domain.indexOf(46)) >= 0) {
            domain = domain.substring(dot);
        }
        this.domain = domain;
    }

    public String buildCookieHeader(URL url) {
        String domain = url.getHost();
        int dot = domain.indexOf(46);
        if (dot >= 0) {
            domain = domain.substring(dot);
        }
        if (domain.equals(this.domain)) {
            String path = url.getPath();
            int secure = url.getProtocol().equalsIgnoreCase("https") ? 1 : 0;
            StringBuffer sb = new StringBuffer();
            for (String key : this.jar.keySet()) {
                Cookie c = this.jar.get(key);
                if (null == c) continue;
                sb.append(c.getHeader(path, secure));
            }
            if (sb.length() > 0) {
                sb.append("\r\n");
                return "Cookie: " + sb.toString();
            }
        }
        return null;
    }

    public void parseCookieHeader(String s) {
        StringTokenizer t = new StringTokenizer(s, ";");
        Cookie cookie = new Cookie();
        while (t.hasMoreTokens()) {
            String v;
            Matcher m = pNvPair.matcher(t.nextToken());
            if (!m.matches()) continue;
            String n = m.group(1);
            String string = v = m.groupCount() > 2 ? m.group(3).trim() : "";
            if (n.compareToIgnoreCase("version") == 0) {
                cookie.version = Integer.parseInt(v);
                continue;
            }
            if (n.compareToIgnoreCase("domain") == 0) {
                cookie.domain = v;
                continue;
            }
            if (n.compareToIgnoreCase("path") == 0) {
                cookie.path = v;
                continue;
            }
            if (n.compareToIgnoreCase("max-age") == 0) {
                cookie.max_age = Integer.parseInt(v);
                if (cookie.max_age < 0L) {
                    cookie.max_age = 0L;
                }
                cookie.max_age *= 1000L;
                cookie.max_age += System.currentTimeMillis();
                continue;
            }
            if (n.compareToIgnoreCase("expires") == 0) {
                SimpleDateFormat df = new SimpleDateFormat("EEE, dd-MMM-yy HH:mm:ss zzz");
                try {
                    cookie.max_age = System.currentTimeMillis() - df.parse(v).getTime();
                    if (cookie.max_age >= 0L) continue;
                    cookie.max_age = 0L;
                }
                catch (ParseException e) {
                    cookie.max_age = 0L;
                }
                continue;
            }
            if (n.compareToIgnoreCase("comment") == 0) continue;
            if (n.compareToIgnoreCase("secure") == 0) {
                cookie.secure = 1;
                continue;
            }
            if (n.startsWith("$")) continue;
            if (null != cookie.name) {
                if (cookie.version > 0) {
                    cookie.domain = this.stripQuotes(cookie.domain);
                    cookie.path = this.stripQuotes(cookie.path);
                }
                if (this.domainMatch(cookie.domain)) {
                    if (cookie.max_age > 0L) {
                        this.jar.put(cookie.getKey(), cookie);
                    } else {
                        this.jar.put(cookie.getKey(), null);
                    }
                }
                try {
                    cookie = cookie.clone();
                }
                catch (CloneNotSupportedException e) {
                    cookie = new Cookie();
                }
            }
            cookie.name = n;
            cookie.value = v;
        }
    }

    private class Cookie
    implements Cloneable {
        String domain = null;
        String name = null;
        String value = null;
        String path = null;
        long max_age = 0L;
        int version = 0;
        int secure = 0;

        Cookie() {
        }

        public Cookie clone() throws CloneNotSupportedException {
            Cookie ret = (Cookie)super.clone();
            ret.domain = this.domain;
            ret.name = this.name;
            ret.value = this.value;
            ret.path = this.path;
            ret.max_age = this.max_age;
            ret.version = this.version;
            ret.secure = this.secure;
            return ret;
        }

        public String getKey() {
            String ret = this.name;
            if (null != this.path) {
                ret = ret + this.path;
            }
            return ret;
        }

        public String getHeader(String path, int secure) {
            StringBuffer sb = new StringBuffer();
            if ((null == this.path || this.path.equals("/") || this.path.startsWith(path)) && this.secure <= secure && this.max_age > System.currentTimeMillis()) {
                if (this.version > 0) {
                    sb.append("$Version=").append(this.version).append("; ");
                    sb.append(this.name).append("=").append(this.value).append(";");
                    if (null != this.path) {
                        sb.append(" $Path=").append(this.path).append(";");
                    }
                    if (null != this.domain) {
                        sb.append(" $Domain=").append(this.domain).append(";");
                    }
                } else {
                    sb.append(this.name).append("=").append(this.value).append(";");
                }
            }
            return sb.toString();
        }
    }
}

