/*
 * Decompiled with CFR 0.152.
 */
package wjhk.jupload2.upload;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetAddress;
import java.util.MissingResourceException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPReply;
import wjhk.jupload2.exception.JUploadException;
import wjhk.jupload2.exception.JUploadExceptionUploadFailed;
import wjhk.jupload2.exception.JUploadIOException;
import wjhk.jupload2.policies.UploadPolicy;
import wjhk.jupload2.upload.DefaultFileUploadThread;
import wjhk.jupload2.upload.FileUploadManagerThread;

public class FileUploadThreadFTP
extends DefaultFileUploadThread {
    private OutputStream ftpOutputStream = null;
    private BufferedOutputStream bufferedOutputStream = null;
    private Matcher uriMatch;
    private FTPClient ftp = new FTPClient();
    private String user;
    private String pass;
    private String host;
    private String port;
    private String dir;
    private boolean bConnected = false;
    public final Pattern ftpPattern = Pattern.compile("^ftp://(([^:]+):([^\\@]+)\\@)?([^/:]+):?([0-9]+)?(/(.*))?$");

    public FileUploadThreadFTP(UploadPolicy uploadPolicy, FileUploadManagerThread fileUploadManagerThread) throws JUploadException {
        super(uploadPolicy, fileUploadManagerThread);
        this.uploadPolicy.displayDebug("  Using " + this.getClass().getName(), 30);
        if (uploadPolicy.getStringUploadSuccess() != null) {
            uploadPolicy.displayWarn("FTP mode: stringUploadSuccess parameter ignored (forced to null)");
            uploadPolicy.setProperty("stringUploadSuccess", null);
        }
        if (uploadPolicy.getNbFilesPerRequest() != 1) {
            uploadPolicy.displayWarn("FTP mode: nbFilesPerRequest parameter ignored (forced to 1)");
            uploadPolicy.setProperty("nbFilesPerRequest", "1");
        }
        if (uploadPolicy.getMaxChunkSize() != Long.MAX_VALUE) {
            uploadPolicy.displayWarn("FTP mode: maxChunkSize parameter ignored (forced to Long.MAX_VALUE)");
            uploadPolicy.setProperty("maxChunkSize", Long.toString(Long.MAX_VALUE));
        }
    }

    void beforeRequest() throws JUploadException {
        if (!this.bConnected) {
            String url = this.uploadPolicy.getPostURL();
            this.uriMatch = this.ftpPattern.matcher(url);
            if (!this.uriMatch.matches()) {
                throw new JUploadException("invalid URI: " + url);
            }
            this.user = this.uriMatch.group(2) == null ? "anonymous" : this.uriMatch.group(2);
            this.pass = this.uriMatch.group(3) == null ? "JUpload" : this.uriMatch.group(3);
            this.host = this.uriMatch.group(4);
            this.port = this.uriMatch.group(5) == null ? "21" : this.uriMatch.group(5);
            this.dir = this.uriMatch.group(7) == null ? "/" : this.uriMatch.group(7);
            try {
                this.ftp.setDefaultPort(Integer.parseInt(this.port));
                this.ftp.connect(this.host);
                this.uploadPolicy.displayDebug("Connected to " + this.host, 10);
                this.uploadPolicy.displayDebug(this.ftp.getReplyString(), 80);
                if (!FTPReply.isPositiveCompletion((int)this.ftp.getReplyCode())) {
                    throw new JUploadException("FTP server refused connection.");
                }
                this.ftp.login(this.user, this.pass);
                this.uploadPolicy.displayDebug(this.ftp.getReplyString(), 80);
                if (!FTPReply.isPositiveCompletion((int)this.ftp.getReplyCode())) {
                    throw new JUploadException("Invalid username / password");
                }
                this.ftp.changeWorkingDirectory(this.dir);
                this.uploadPolicy.displayDebug(this.ftp.getReplyString(), 80);
                if (!FTPReply.isPositiveCompletion((int)this.ftp.getReplyCode())) {
                    throw new JUploadException("Invalid directory specified");
                }
                this.bConnected = true;
            }
            catch (Exception e) {
                throw new JUploadIOException("Could not connect to server (" + e.getMessage() + ")", e);
            }
        }
    }

    void afterFile(int index) {
    }

    void beforeFile(int index) throws JUploadException {
        try {
            this.setTransferType(index);
            this.ftpOutputStream = this.ftp.storeFileStream(this.filesToUpload[index].getFileName());
            this.bufferedOutputStream = new BufferedOutputStream(this.ftpOutputStream);
        }
        catch (IOException e) {
            throw new JUploadException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void cleanAll() {
        try {
            block4: {
                try {
                    if (!this.ftp.isConnected()) break block4;
                    this.ftp.disconnect();
                    this.uploadPolicy.displayDebug("disconnected", 50);
                }
                catch (IOException e) {
                    this.uploadPolicy.displayDebug("Not connected", 50);
                    Object var3_2 = null;
                    this.ftpOutputStream = null;
                    this.bufferedOutputStream = null;
                }
            }
            Object var3_1 = null;
            this.ftpOutputStream = null;
            this.bufferedOutputStream = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.ftpOutputStream = null;
            this.bufferedOutputStream = null;
            throw throwable;
        }
    }

    void cleanRequest() throws JUploadException {
        if (this.bufferedOutputStream != null) {
            try {
                try {
                    this.bufferedOutputStream.close();
                    this.ftpOutputStream.close();
                    if (!this.ftp.completePendingCommand()) {
                        throw new JUploadExceptionUploadFailed("ftp.completePendingCommand() returned false");
                    }
                    Object var3_1 = null;
                    this.bufferedOutputStream = null;
                }
                catch (IOException e) {
                    throw new JUploadException(e);
                }
            }
            catch (Throwable throwable) {
                Object var3_2 = null;
                this.bufferedOutputStream = null;
                throw throwable;
            }
        }
    }

    int finishRequest() throws JUploadException {
        try {
            this.getOutputStream().flush();
            return 200;
        }
        catch (IOException ioe) {
            throw new JUploadIOException("FileUploadThreadFTP.finishRequest()", ioe);
        }
        catch (Exception e) {
            throw new JUploadException("FileUploadThreadFTP.finishRequest()  (check the user permission on the server)", e);
        }
    }

    long getAdditionnalBytesForUpload(int indexFile) {
        return 0L;
    }

    OutputStream getOutputStream() {
        return this.bufferedOutputStream;
    }

    void startRequest(long contentLength, boolean bChunkEnabled, int chunkPart, boolean bLastChunk) {
    }

    private void setTransferType(int index) throws IOException {
        try {
            String binVal = this.uploadPolicy.getString("binary");
            if (Boolean.getBoolean(binVal)) {
                this.ftp.setFileType(2);
            } else {
                this.ftp.setFileType(0);
            }
        }
        catch (MissingResourceException e) {
            this.ftp.setFileType(2);
        }
        try {
            String pasVal = this.uploadPolicy.getString("passive");
            if (Boolean.getBoolean(pasVal)) {
                this.ftp.enterRemotePassiveMode();
                this.ftp.enterLocalPassiveMode();
            } else {
                this.ftp.enterLocalActiveMode();
                this.ftp.enterRemoteActiveMode(InetAddress.getByName(this.host), Integer.parseInt(this.port));
            }
        }
        catch (MissingResourceException e) {
            this.ftp.enterRemotePassiveMode();
            this.ftp.enterLocalPassiveMode();
        }
    }
}

