/*
 * Decompiled with CFR 0.152.
 */
package wjhk.jupload2.upload;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JProgressBar;
import javax.swing.Timer;
import wjhk.jupload2.exception.JUploadException;
import wjhk.jupload2.filedata.FileData;
import wjhk.jupload2.gui.JUploadPanel;
import wjhk.jupload2.gui.filepanel.FilePanel;
import wjhk.jupload2.gui.filepanel.SizeRenderer;
import wjhk.jupload2.policies.UploadPolicy;
import wjhk.jupload2.upload.FileUploadThread;
import wjhk.jupload2.upload.FileUploadThreadFTP;
import wjhk.jupload2.upload.FileUploadThreadHTTP;
import wjhk.jupload2.upload.UploadFileData;

public class FileUploadManagerThread
extends Thread
implements ActionListener {
    public static final int UPLOAD_STATUS_NOT_STARTED = 1;
    public static final int UPLOAD_STATUS_UPLOADING = 2;
    public static final int UPLOAD_STATUS_UPLOADED_WAITING_FOR_RESPONSE = 3;
    public static final int UPLOAD_STATUS_UPLOADED = 4;
    private FilePanel filePanel = null;
    private FileUploadThread fileUploadThread = null;
    long maxChunkSize = -1L;
    private long nbBytesReadyForUpload = 0L;
    private int nbFilesBeingUploaded = 0;
    int nbFilesPerRequest = -1;
    private int nbPreparedFiles = 0;
    private int nbUploadedFiles = 0;
    private long nbBytesUploadedForCurrentFile = 0L;
    private long nbTotalNumberOfPreparedBytes = 0L;
    private int numOfFileInCurrentRequest = 0;
    private int uploadStatus = 1;
    private UploadFileData[] nextPacket = null;
    private JProgressBar preparationProgressBar = null;
    private JProgressBar uploadProgressBar = null;
    private boolean uploadFinished = false;
    private long uploadStartTime = 0L;
    private boolean stop = false;
    private long estimatedTotalLength = 0L;
    private JUploadException uploadException = null;
    private long uploadedLength = 0L;
    private JUploadPanel uploadPanel = null;
    private UploadPolicy uploadPolicy = null;
    private UploadFileData[] uploadFileDataArray = null;
    private static final int DEFAULT_TIMEOUT = 100;
    private static final int PROGRESS_INTERVAL = 10;
    private int update_counter = 0;
    private Timer timerUpload = new Timer(100, this);

    public FileUploadManagerThread(UploadPolicy uploadPolicy) {
        super("FileUploadManagerThread thread");
        this.uploadPolicy = uploadPolicy;
        this.uploadPanel = uploadPolicy.getApplet().getUploadPanel();
        this.filePanel = this.uploadPanel.getFilePanel();
        this.uploadProgressBar = this.uploadPanel.getUploadProgressBar();
        this.preparationProgressBar = this.uploadPanel.getPreparationProgressBar();
        this.createUploadThread();
        this.nbFilesPerRequest = this.uploadPolicy.getNbFilesPerRequest();
        this.maxChunkSize = this.uploadPolicy.getMaxChunkSize();
        FileData[] fileDataArray = this.uploadPanel.getFilePanel().getFiles();
        this.uploadFileDataArray = new UploadFileData[fileDataArray.length];
        for (int i = 0; i < this.uploadFileDataArray.length; ++i) {
            this.uploadFileDataArray[i] = new UploadFileData(fileDataArray[i], this, this.uploadPolicy);
        }
    }

    public final void run() {
        try {
            this.uploadPolicy.displayDebug("Start of the FileUploadManagerThread", 5);
            this.uploadPanel.updateButtonState();
            this.initProgressBar();
            this.timerUpload.start();
            this.uploadPolicy.displayDebug("Timer started", 50);
            this.prepareFiles();
            while (this.fileUploadThread != null && this.fileUploadThread.isAlive() && this.nbUploadedFiles < this.uploadFileDataArray.length && !this.stop) {
                try {
                    this.fileUploadThread.join(100L);
                }
                catch (InterruptedException e) {
                    this.uploadPolicy.displayWarn("An InterruptedException occured in FileUploadManagerThread.run()");
                }
            }
            this.uploadFinished = true;
            this.uploadPanel.updateButtonState();
            this.uploadPolicy.getApplet().getAppletContext().showStatus("");
            this.uploadPolicy.getApplet().getUploadPanel().getStatusLabel().setText("");
            if (this.getUploadException() == null) {
                this.afterUploadOk();
            }
            try {
                FileUploadManagerThread.sleep(5000L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            this.preparationProgressBar.setValue(0);
            this.preparationProgressBar.setString("");
            this.uploadProgressBar.setValue(0);
            this.uploadProgressBar.setString("");
            this.uploadPolicy.displayDebug("End of the FileUploadManagerThread", 5);
        }
        catch (JUploadException jue) {
            if (this.uploadException == null) {
                this.uploadException = jue;
            }
            this.uploadPolicy.displayErr("Uncaught exception in FileUploadManagerThread/run()", jue);
            this.stopUpload();
            this.uploadPanel.updateButtonState();
        }
    }

    public long getEstimatedTotalLength() {
        return this.estimatedTotalLength;
    }

    public Exception getException() {
        return this.uploadException;
    }

    public int getNbUploadedFiles() {
        return this.nbUploadedFiles;
    }

    public final long getUploadStartTime() {
        return this.uploadStartTime;
    }

    public long getUploadedLength() {
        return this.uploadedLength;
    }

    public void setUploadException(JUploadException uploadException) {
        this.uploadPolicy.displayErr(uploadException);
        this.uploadException = uploadException;
    }

    public JUploadException getUploadException() {
        return this.uploadException;
    }

    public boolean isUploadFinished() {
        return this.uploadFinished;
    }

    public boolean isUploadStopped() {
        return this.stop;
    }

    public synchronized void nbBytesUploaded(long nbBytes) throws JUploadException {
        this.uploadedLength += nbBytes;
        this.nbBytesUploadedForCurrentFile += nbBytes;
        this.updateUploadProgressBar();
    }

    public synchronized void setUploadStatus(int numOfFileInCurrentRequest, int uploadStatus) throws JUploadException {
        this.numOfFileInCurrentRequest = numOfFileInCurrentRequest;
        this.uploadStatus = uploadStatus;
        this.updateUploadProgressBar();
    }

    public void stopUpload() {
        this.stop = true;
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() instanceof Timer) {
            if (this.isUploadFinished()) {
                this.timerUpload.stop();
            } else if (this.update_counter++ > 10 || !this.fileUploadThread.isAlive()) {
                this.updateUploadStatusBar();
            }
        }
    }

    private void updateUploadStatusBar() {
        this.update_counter = 0;
        if (null != this.uploadProgressBar && this.getUploadStartTime() != 0L) {
            String eta;
            double cps;
            double percent;
            long duration = (System.currentTimeMillis() - this.getUploadStartTime()) / 1000L;
            double done = this.getUploadedLength();
            double total = this.getEstimatedTotalLength();
            try {
                percent = 100.0 * done / total;
            }
            catch (ArithmeticException e1) {
                percent = 100.0;
            }
            try {
                cps = done / (double)duration;
            }
            catch (ArithmeticException e1) {
                cps = done;
            }
            try {
                long remaining = (long)((total - done) / cps);
                eta = remaining > 3600L ? String.format(this.uploadPolicy.getString("timefmt_hms"), new Long(remaining / 3600L), new Long(remaining / 60L % 60L), new Long(remaining % 60L)) : (remaining > 60L ? String.format(this.uploadPolicy.getString("timefmt_ms"), new Long(remaining / 60L), new Long(remaining % 60L)) : String.format(this.uploadPolicy.getString("timefmt_s"), new Long(remaining)));
            }
            catch (ArithmeticException e1) {
                eta = this.uploadPolicy.getString("timefmt_unknown");
            }
            String format = this.uploadPolicy.getString("status_msg");
            String status = String.format(format, new Integer((int)percent), SizeRenderer.formatFileUploadSpeed(cps, this.uploadPolicy), eta);
            this.uploadPanel.getStatusLabel().setText(status);
            this.uploadPolicy.getApplet().getAppletContext().showStatus(status);
        }
    }

    private synchronized boolean checkIfNextPacketIsReady() throws JUploadException {
        if (this.nextPacket == null && this.nbUploadedFiles + this.nbFilesBeingUploaded != this.nbPreparedFiles) {
            int nbFilesInPacket;
            int maxPacketSize = Math.min(this.nbPreparedFiles - this.nbUploadedFiles - this.nbFilesBeingUploaded, this.nbFilesPerRequest);
            FileData[] tempFileData = new FileData[maxPacketSize];
            long packetLength = 0L;
            boolean isPacketFinished = false;
            for (nbFilesInPacket = 0; nbFilesInPacket < maxPacketSize; ++nbFilesInPacket) {
                if (nbFilesInPacket > 0 && packetLength + this.uploadFileDataArray[nbFilesInPacket].getUploadLength() > this.maxChunkSize) {
                    isPacketFinished = true;
                    break;
                }
                tempFileData[nbFilesInPacket] = this.uploadFileDataArray[this.nbUploadedFiles + this.nbFilesBeingUploaded + nbFilesInPacket];
            }
            if (this.nbUploadedFiles + this.nbFilesBeingUploaded + nbFilesInPacket == this.uploadFileDataArray.length) {
                isPacketFinished = true;
            } else if (nbFilesInPacket == this.nbFilesPerRequest) {
                isPacketFinished = true;
            }
            if (isPacketFinished) {
                this.nextPacket = new UploadFileData[nbFilesInPacket];
                System.arraycopy(tempFileData, 0, this.nextPacket, 0, nbFilesInPacket);
            }
        }
        return this.nextPacket != null;
    }

    private synchronized void anotherFileIsReady(FileData newlyPreparedFileData) throws JUploadException {
        ++this.nbPreparedFiles;
        this.nbBytesReadyForUpload += newlyPreparedFileData.getUploadLength();
        this.nbTotalNumberOfPreparedBytes += newlyPreparedFileData.getUploadLength();
        this.estimatedTotalLength = this.nbTotalNumberOfPreparedBytes / (long)this.nbPreparedFiles;
    }

    public synchronized void anotherFileHasBeenUploaded(FileData newlyUploadedFileData) throws JUploadException {
        this.uploadPolicy.displayWarn("-- In anotherFileHasBeenUploaded()");
        ++this.nbUploadedFiles;
        --this.nbFilesBeingUploaded;
        this.nbBytesUploadedForCurrentFile = 0L;
        this.nbBytesReadyForUpload -= newlyUploadedFileData.getUploadLength();
        this.uploadStatus = 4;
        this.updateUploadProgressBar();
        this.filePanel.remove(newlyUploadedFileData);
    }

    public synchronized UploadFileData[] getNextPacket() throws JUploadException {
        if (this.nextPacket == null) {
            this.checkIfNextPacketIsReady();
        }
        if (this.nextPacket == null) {
            return null;
        }
        if (this.nbUploadedFiles == 0 && this.uploadStartTime == 0L) {
            this.uploadStartTime = System.currentTimeMillis();
        }
        UploadFileData[] fileDataTmp = this.nextPacket;
        this.nextPacket = null;
        this.nbFilesBeingUploaded += fileDataTmp.length;
        return fileDataTmp;
    }

    private synchronized void updateUploadProgressBar() throws JUploadException {
        String msgInfoUploaded = this.uploadPolicy.getString("infoUploaded");
        String msgInfoUploading = this.uploadPolicy.getString("infoUploading");
        String msgNbUploadedFiles = this.uploadPolicy.getString("nbUploadedFiles");
        int percent = 0;
        if (this.nbBytesUploadedForCurrentFile == 0L || this.nbUploadedFiles == this.uploadFileDataArray.length) {
            percent = 0;
        } else {
            percent = (int)(this.nbBytesUploadedForCurrentFile * 100L / this.uploadFileDataArray[this.nbUploadedFiles].getUploadLength());
            if (percent > 100) {
                this.uploadPolicy.displayWarn("percent is more than 100 (" + percent + ") in FileUploadManagerThread.update.UploadProgressBar");
                percent = 100;
            }
        }
        this.uploadPolicy.displayDebug("   ProgressBar value: " + (100 * this.nbUploadedFiles + percent), 101);
        this.uploadProgressBar.setValue(100 * this.nbUploadedFiles + percent);
        String msg = null;
        switch (this.uploadStatus) {
            case 1: {
                msg = "";
                break;
            }
            case 2: {
                msg = String.format(msgInfoUploading, this.nbUploadedFiles + 1);
                break;
            }
            case 3: {
                msg = this.numOfFileInCurrentRequest == 1 ? this.nbUploadedFiles + "/" + this.uploadFileDataArray.length : this.nbUploadedFiles - this.numOfFileInCurrentRequest + 1 + "-" + this.nbUploadedFiles + "/" + this.uploadFileDataArray.length;
                msg = String.format(msgInfoUploaded, msg);
                break;
            }
            case 4: {
                msg = String.format(msgNbUploadedFiles, this.nbUploadedFiles);
                break;
            }
            default: {
                this.uploadPolicy.displayWarn("Unknown upload status in FileUploadManagerThread.updateProgressBar(): " + this.uploadStatus);
            }
        }
        this.uploadProgressBar.setString(msg);
        this.uploadProgressBar.repaint();
    }

    private void prepareFiles() {
        this.preparationProgressBar.setMaximum(100 * this.uploadFileDataArray.length);
        try {
            for (int i = 0; i < this.uploadFileDataArray.length; ++i) {
                this.uploadPolicy.displayDebug("============== Start of file preparation (" + this.uploadFileDataArray[i].getFileName() + ")", 30);
                this.preparationProgressBar.setString(String.format(this.uploadPolicy.getString("preparingFile"), new Integer(i + 1), new Integer(this.uploadFileDataArray.length)));
                this.preparationProgressBar.repaint(100L);
                this.uploadFileDataArray[i].beforeUpload();
                this.uploadPolicy.displayDebug("============== End of file preparation (" + this.uploadFileDataArray[i].getFileName() + ")", 30);
                this.anotherFileIsReady(this.uploadFileDataArray[i]);
                this.preparationProgressBar.setValue(this.nbPreparedFiles * 100);
                this.preparationProgressBar.repaint();
            }
        }
        catch (JUploadException e) {
            this.uploadException = e;
            this.uploadPolicy.displayErr(e);
            this.preparationProgressBar.setString(e.getMessage());
            this.stopUpload();
        }
    }

    private void afterUploadOk() {
        this.uploadPolicy.displayDebug("FileUploadManagerThread: in afterUploadOk()", 10);
        String svrRet = this.fileUploadThread.getResponseMsg();
        try {
            this.uploadPolicy.afterUpload(this.getUploadException(), svrRet);
        }
        catch (JUploadException e1) {
            this.uploadPolicy.displayErr("error in uploadPolicy.afterUpload (JUploadPanel)", e1);
        }
    }

    private void createUploadThread() {
        try {
            this.fileUploadThread = this.uploadPolicy.getPostURL().substring(0, 4).equals("ftp:") ? new FileUploadThreadFTP(this.uploadPolicy, this) : new FileUploadThreadHTTP(this.uploadPolicy, this);
        }
        catch (JUploadException e1) {
            this.uploadPolicy.displayErr(e1);
        }
        this.fileUploadThread.start();
    }

    private synchronized void initProgressBar() throws JUploadException {
        this.preparationProgressBar.setMaximum(100 * this.uploadFileDataArray.length);
        this.preparationProgressBar.setString("");
        this.uploadProgressBar.setMaximum(100 * this.uploadFileDataArray.length);
        this.uploadProgressBar.setString("");
        this.updateUploadProgressBar();
    }
}

