/*
 * Decompiled with CFR 0.152.
 */
package wjhk.jupload2.upload;

import java.io.OutputStream;
import java.util.regex.Pattern;
import wjhk.jupload2.exception.JUploadException;
import wjhk.jupload2.exception.JUploadExceptionUploadFailed;
import wjhk.jupload2.exception.JUploadIOException;
import wjhk.jupload2.policies.UploadPolicy;
import wjhk.jupload2.upload.FileUploadManagerThread;
import wjhk.jupload2.upload.FileUploadThread;
import wjhk.jupload2.upload.UploadFileData;

public abstract class DefaultFileUploadThread
extends Thread
implements FileUploadThread {
    UploadFileData[] filesToUpload = null;
    private FileUploadManagerThread fileUploadManagerThread = null;
    protected UploadPolicy uploadPolicy = null;
    private long maxChunkSize;
    protected String responseMsg = "";
    protected String responseBody = "";

    public DefaultFileUploadThread(UploadPolicy uploadPolicy, FileUploadManagerThread fileUploadManagerThread) {
        super("FileUploadThread");
        this.uploadPolicy = uploadPolicy;
        this.fileUploadManagerThread = fileUploadManagerThread;
        this.maxChunkSize = this.uploadPolicy.getMaxChunkSize();
        this.uploadPolicy.displayDebug("DefaultFileUploadThread created", 30);
    }

    abstract long getAdditionnalBytesForUpload(int var1) throws JUploadIOException;

    abstract void beforeRequest() throws JUploadException;

    abstract void startRequest(long var1, boolean var3, int var4, boolean var5) throws JUploadException;

    abstract int finishRequest() throws JUploadException;

    abstract void beforeFile(int var1) throws JUploadException;

    abstract void afterFile(int var1) throws JUploadException;

    abstract void cleanRequest() throws JUploadException;

    abstract void cleanAll() throws JUploadException;

    abstract OutputStream getOutputStream() throws JUploadException;

    public String getResponseBody() {
        return this.responseBody;
    }

    public String getResponseMsg() {
        return this.responseMsg;
    }

    void setResponseBody(String body) {
        this.responseBody = this.normalizeCRLF(body);
    }

    void setResponseMsg(String msg) {
        this.responseMsg = this.normalizeCRLF(msg);
    }

    public final void run() {
        this.uploadPolicy.displayDebug("Start of the FileUploadThread", 5);
        try {
            while (!this.fileUploadManagerThread.isUploadStopped() && !this.fileUploadManagerThread.isUploadFinished()) {
                this.filesToUpload = this.fileUploadManagerThread.getNextPacket();
                if (this.filesToUpload != null) {
                    this.uploadPolicy.displayDebug("Before do upload", 5);
                    this.doUpload();
                    this.uploadPolicy.displayDebug("After do upload", 5);
                    continue;
                }
                try {
                    DefaultFileUploadThread.sleep(200L);
                }
                catch (InterruptedException e) {}
            }
        }
        catch (JUploadException e) {
            this.fileUploadManagerThread.setUploadException(e);
        }
        this.uploadPolicy.displayDebug("End of the FileUploadThread", 5);
    }

    private final void doUpload() throws JUploadException {
        boolean bChunkEnabled = false;
        long totalContentLength = 0L;
        long totalFileLength = 0L;
        this.fileUploadManagerThread.setUploadStatus(0, 2);
        this.beforeRequest();
        for (int i = 0; i < this.filesToUpload.length && !this.fileUploadManagerThread.isUploadStopped(); ++i) {
            totalContentLength += this.filesToUpload[i].getUploadLength();
            totalContentLength += this.getAdditionnalBytesForUpload(i);
            totalFileLength += this.filesToUpload[i].getUploadLength();
            this.uploadPolicy.displayDebug("file " + (this.fileUploadManagerThread.getNbUploadedFiles() + i) + ": content=" + this.filesToUpload[i].getUploadLength() + " bytes, getAdditionnalBytesForUpload=" + this.getAdditionnalBytesForUpload(i) + " bytes", 50);
        }
        if (totalFileLength >= this.maxChunkSize) {
            if (this.filesToUpload.length > 1) {
                this.fileUploadManagerThread.setUploadException(new JUploadException("totalContentLength >= chunkSize: this.filesToUpload.length should be more than 1 (doUpload)"));
            }
            bChunkEnabled = true;
        }
        if (bChunkEnabled) {
            this.doChunkedUpload(totalContentLength, totalFileLength);
        } else {
            this.doNonChunkedUpload(totalContentLength, totalFileLength);
        }
        this.fileUploadManagerThread.setUploadStatus(this.filesToUpload.length, 4);
    }

    private final void doChunkedUpload(long totalContentLength, long totalFileLength) throws JUploadException {
        boolean bLastChunk = false;
        int chunkPart = 0;
        long contentLength = 0L;
        long thisChunkSize = 0L;
        if (this.filesToUpload.length > 1) {
            throw new JUploadException("totalContentLength >= chunkSize: this.filesToUpload.length should be more than 1 (doUpload)");
        }
        while (!bLastChunk && this.fileUploadManagerThread.getUploadException() == null && !this.fileUploadManagerThread.isUploadStopped()) {
            bLastChunk = contentLength > this.filesToUpload[0].getRemainingLength();
            thisChunkSize = bLastChunk ? this.filesToUpload[0].getRemainingLength() : this.maxChunkSize;
            contentLength = thisChunkSize + this.getAdditionnalBytesForUpload(0);
            this.startRequest(contentLength, true, ++chunkPart, bLastChunk);
            this.beforeFile(0);
            this.filesToUpload[0].uploadFile(this.getOutputStream(), thisChunkSize);
            if (bLastChunk && this.filesToUpload[0].getRemainingLength() > 0L) {
                throw new JUploadExceptionUploadFailed("Files has not be entirely uploaded. The remaining size is " + this.filesToUpload[0].getRemainingLength() + " bytes. File size was: " + this.filesToUpload[0].getUploadLength() + " bytes.");
            }
            this.afterFile(0);
            int status = this.finishRequest();
            this.uploadPolicy.checkUploadSuccess(status, this.getResponseMsg(), this.getResponseBody());
            this.cleanRequest();
        }
        this.fileUploadManagerThread.anotherFileHasBeenUploaded(this.filesToUpload[0]);
    }

    private final void doNonChunkedUpload(long totalContentLength, long totalFileLength) throws JUploadException {
        this.startRequest(totalContentLength, false, 0, true);
        for (int i = 0; i < this.filesToUpload.length && !this.fileUploadManagerThread.isUploadStopped(); ++i) {
            this.fileUploadManagerThread.setUploadStatus(i, 2);
            this.beforeFile(i);
            this.filesToUpload[i].uploadFile(this.getOutputStream(), this.filesToUpload[i].getUploadLength());
            this.afterFile(i);
            this.fileUploadManagerThread.anotherFileHasBeenUploaded(this.filesToUpload[i]);
        }
        this.fileUploadManagerThread.setUploadStatus(this.filesToUpload.length, 3);
        int status = this.finishRequest();
        this.uploadPolicy.checkUploadSuccess(status, this.getResponseMsg(), this.getResponseBody());
        this.cleanRequest();
    }

    public void close() {
        try {
            this.cleanAll();
        }
        catch (JUploadException e) {
            this.uploadPolicy.displayErr(e);
        }
    }

    public final String normalizeCRLF(String s) {
        Pattern p = Pattern.compile("\\r\\n|\\r|\\n", 8);
        String[] lines = p.split(s);
        StringBuffer sb = new StringBuffer(s.length() * 2);
        for (int i = 0; i < lines.length; ++i) {
            sb.append(lines[i]).append("\r\n");
        }
        return sb.toString();
    }

    public final String quoteCRLF(String s) {
        return s.replaceAll("\r\n", "\\\\r\\\\n\n");
    }
}

