<?php
/**
 *  Xoops footer
 *
 * You may not change or alter any portion of this comment or credits
 * of supporting developers from this source code or any supporting source code
 * which is considered copyrighted (c) material of the original comment or credit authors.
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * @copyright       The XOOPS Project http://sourceforge.net/projects/xoops/
 * @license         http://www.fsf.org/copyleft/gpl.html GNU public license
 * @package         kernel
 * @since           2.0.0
 * @version         $Id: footer.php 4897 2010-06-19 02:55:48Z phppp $
 */
 
defined('XOOPS_ROOT_PATH') or die('Restricted access');

$xoopsPreload =& XoopsPreload::getInstance();
$xoopsPreload->triggerEvent('core.footer.start');

if (! defined("XOOPS_FOOTER_INCLUDED")) {
    define("XOOPS_FOOTER_INCLUDED", 1);

    $xoopsLogger =& XoopsLogger::getInstance();
    $xoopsLogger->stopTime('Module display');

    if ($xoopsOption['theme_use_smarty'] == 0) {
        // the old way
        $footer = htmlspecialchars($xoopsConfigMetaFooter['footer']) . '<br /><div style="text-align:center">Powered by XOOPS &copy; <a href="http://xoops.sourceforge.net/" rel="external">The XOOPS Project</a></div>';
        if (isset($xoopsOption['template_main'])) {
            $xoopsTpl->xoops_setCaching(0);
            $xoopsTpl->display('db:' . $xoopsOption['template_main']);
        }
        if (!isset($xoopsOption['show_rblock'])) {
            $xoopsOption['show_rblock'] = 0;
        }
        themefooter($xoopsOption['show_rblock'], $footer);
        xoops_footer();
    } else {
        // RMV-NOTIFY
        include_once $GLOBALS['xoops']->path('include/notification_select.php');
        if (! headers_sent()) {
            header('Content-Type:text/html; charset=' . _CHARSET);
            header('Expires: Mon, 26 Jul 1997 05:00:00 GMT');
            //header('Last-Modified: '.gmdate('D, d M Y H:i:s').' GMT');
            header('Cache-Control: private, no-cache');
            header('Pragma: no-cache');
        }

        //@internal: using global $xoTheme dereferences the variable in old versions, this does not
        if (!isset($xoTheme)) {
            $xoTheme =& $GLOBALS['xoTheme'];
        }

        if (isset($xoopsOption['template_main']) && $xoopsOption['template_main'] != $xoTheme->contentTemplate) {
            trigger_error("xoopsOption[template_main] should be defined before including header.php", E_USER_WARNING);
            if (false === strpos($xoopsOption['template_main'], ':')) {
                $xoTheme->contentTemplate = 'db:' . $xoopsOption['template_main'];
            } else {
                $xoTheme->contentTemplate = $xoopsOption['template_main'];
            }
        }

        $xoTheme->render();
    }
    $xoopsLogger->stopTime();
}

$xoopsPreload->triggerEvent('core.footer.end');
?>