<?php
/**
* XOOPS installation md5 checksumminig script
*
* This script allows you to check that the XOOPS system files have been correctly uploaded.
* It reads all the XOOPS files and reports missing or invalid ones.
* 
* Instructions:
* - Upload this script and xoops.md5 to your XOOPS documents root
* - Access it using a browser
* - Re-upload missing/invalid files
*
* @copyright	The XOOPS project http://www.xoops.org/
* @license      http://www.fsf.org/copyleft/gpl.html GNU public license
* @author       Skalpa Keo <skalpa@xoops.org>
* @since        2.0.14
* @version		$Id: xoops_md5.php 815 2006-11-15 20:59:35Z skalpa $
* @package 		xoops
*/

error_reporting( 0 );

header( "Content-type: text/plain" );

if ( !is_file( "xoops.md5" ) || !is_readable( "xoops.md5" ) ) {
	echo "xoops.md5 file not found.\n";
	exit();
}
$sums = explode( "\n", rtrim( file_get_contents( "xoops.md5" ) ) );

foreach ( $sums as $line ) {
	list( $file, $sum ) = explode( ":", $line, 2 );
	if ( substr( $file, 0, 7 ) == 'htdocs/' ) {
		$file = substr( $file, 7 );
	}
	if ( !file_exists( $file ) ) {
		echo "$file missing !\n";
	} else {
		$txt = file_get_contents( "$file" );
		$txt = str_replace( array( "\r\n", "\r" ), "\n", $txt );
		if ( md5($txt) != $sum ) {
			echo "$file content invalid\n";
		}
	}
}

echo "End of files check.\n";
