<?php
// File: $Id: print.php,v 1.49.2.1 2002/05/16 12:03:51 eugeniobaldi Exp $ $Name:  $
// ----------------------------------------------------------------------
// POSTNUKE Content Management System
// Copyright (C) 2001 by the PostNuke Development Team.
// http://www.postnuke.com/
// ----------------------------------------------------------------------
// Based on:
// PHP-NUKE Web Portal System - http://phpnuke.org/
// Thatware - http://thatware.org/
// ----------------------------------------------------------------------
// LICENSE
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License (GPL)
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// To read the license please visit http://www.gnu.org/copyleft/gpl.html
// ----------------------------------------------------------------------
// Original Author of file: Francisco Burzi
// Purpose of file: Displays a printer friendly (story) page
// ----------------------------------------------------------------------

include 'includes/pnAPI.php';
pnInit();
include 'includes/legacy.php';
// eugenio themeover 20020413
// pnThemeLoad();


if(!isset($sid)) {
    pnRedirect('index.php');
}

if (!pnLocalReferer() && pnConfigGetVar('refereronprint')) {
    pnRedirect("modules.php?op=modload&name=News&file=article&sid=$sid");
    exit;
}

function PrintPage($sid) {
    list($dbconn) = pnDBGetConn();
    $pntable = pnDBGetTables();
    // grab the actual story from the database
    $column = &$pntable['stories_column'];
    $result = $dbconn->Execute("SELECT $column[title],
                                     $column[time],
                                     $column[hometext],
                                     $column[bodytext],
                                     $column[topic],
                                     $column[notes],
                                     $column[cid],
                                     $column[aid]
                              FROM $pntable[stories] where $column[sid] = ".pnVarPrepForStore($sid)."");
    list($title, $time, $hometext, $bodytext, $topic, $notes, $cid, $aid) = $result->fields;

    if ($dbconn->ErrorNo() != 0) {
        include 'header.php';
        echo "Error with database query<P>";
        include 'footer.php';
        exit;
    }

    // Get data for "autorise check"
    // Just a temp. solution; Print.php needs completely redesign by using getArticles() and genArticleInfo()
    $column = &$pntable['stories_cat_column'];
    $result = $dbconn->Execute("SELECT $column[title] FROM $pntable[stories_cat] WHERE $column[catid] = ".pnVarPrepForStore($cid)."");
    list($cattitle) = $result->fields;
    if (!pnSecAuthAction(0, 'Stories::', "$aid:$cattitle:$sid", ACCESS_READ)) {
        include "header.php";
        echo "Not authorised to view story \"$title\"";
        include "footer.php";
        exit;
    }

    // Increment the read counter
    $column = &$pntable['stories_column'];
    $dbconn->Execute("UPDATE $pntable[stories] SET $column[counter]=$column[counter]+1 WHERE $column[sid]=".pnVarPrepForStore($sid)."");

    // grab the topictext for the story
    $column2 = &$pntable['topics_column'];
    $result2 = $dbconn->Execute("SELECT $column2[topictext] FROM $pntable[topics] WHERE $column2[tid]=".pnVarPrepForStore($topic)."");
    list($topictext) = $result2->fields;

    $datetime = formatTimestamp($time);

    $cWhereIsPerso = WHERE_IS_PERSO;

    if (!empty($cWhereIsPerso)) {
        include("modules/NS-Multisites/print.inc.php");
    } else {
        $themesarein = "";

        $ThemeSel = pnUserGetTheme();
    }

    pnModAPILoad('Wiki', 'user');
    list($title,
         $hometext,
         $bodytext,
         $notes) = pnModAPIFunc('wiki',
                                'user',
                                'transform',
                                array('objectid' => $sid,
                                      'extrainfo' => array($title,
                                                           $hometext,
                                                           $bodytext,
                                                           $notes)));

    echo "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\" \"http://www.w3.org/TR/html4/loose.dtd\">\n"
        ."<html>"
        ."<head><title>" . pnConfigGetVar('sitename') . "</title>";

    if (defined("_CHARSET") && _CHARSET != "") {
        echo "<META HTTP-EQUIV=\"Content-Type\" ".
            "CONTENT=\"text/html; charset="._CHARSET."\">\n";
    }

    echo "<link rel=\"stylesheet\" type=\"text/css\" href=\"".$themesarein."themes/$ThemeSel/style/style.css\">";
    echo "<style type=\"text/css\">"
        ."<!--"
        .".print {  color: #000000; background-color: #FFFFFF}"
        ."-->"
        ."</style>";
    echo "</head>"
    ."<body class=\"print\" bgcolor=\"#FFFFFF\" text=\"#000000\">";
    echo "<center><table border=\"0\"><tr><td><table border=\"0\" width=\"100%\" cellpadding=\"0\" cellspacing=\"1\" bgcolor=\"#FFFFFF\">";
    echo "<tr><td>"
    ."<table border=\"0\" width=\"100%\" cellpadding=\"20\" cellspacing=\"1\" bgcolor=\"#FFFFFF\">"
        ."<tr><td align=\"center\">"
    ."<img src=\"".WHERE_IS_PERSO."images/" . pnConfigGetVar('site_logo') . "\" border=\"0\" alt=\"\">"
        ."<br><br>"
    ."<font class=\"pn-title\">" . pnVarPrepHTMLDisplay($title) . "</font><br>"
    ."<font class=\"pn-sub\">"._DATE." $datetime<br>"._TOPIC." $topictext</font>"
        ."<br><br>"
        ."</td></tr>"
        ."<tr><td>"
    ."<font class=\"pn-normal\">"
    . pnVarPrepHTMLDisplay($hometext) . "<br>";

    if (!empty($bodytext)) {
        echo pnVarPrepHTMLDisplay($bodytext) . "<br>";
    }
    if (!empty($notes)) {
        echo pnVarPrepHTMLDisplay($notes) . "<br>";
    } else {
        echo "<br>";
    }

    echo "</font>"
    ."</td></tr>"
    ."<tr><td align=\"center\">"
    ."<font class=\"pn-normal\">"
    .""._COMESFROM." " . pnConfigGetVar('sitename') . "<br>"
    ."<a class=\"pn-normal\" href=\"" . pnGetBaseURL() . "\">"
    .pnGetBaseURL()
    ."</a>"
    ."<br><br>"
    .""._THEURL.""
    ."<br>"
    ."<a class=\"pn-normal\" href=\"" . pnGetBaseURL() . "modules.php?op=modload&amp;name=News&amp;file=article&amp;sid=$sid\">"
    . pnGetBaseURL() . "modules.php?op=modload&amp;name=News&amp;file=article&amp;sid=$sid"
    ."</a>"
    ."</font>"
    ."</td></tr>"
    ."</table></td></tr></table>"
    ."</td>"
    ."</tr>"
    ."</table>"
    ."</center>"
    ."</body>"
    ."</html>";

}

PrintPage($sid);

?>